/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Collections;
using System.Drawing;
using System.Globalization;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.SessionState;
using System.Web;

using Borland.Eco.UmlRt;
using Borland.Eco.Subscription;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.Services;
using Borland.Eco.Handles;

namespace Borland.Eco.Web
{
#region Helper classes
	public sealed class TriggerControlsRefresher
	{
		private Control m_TriggerHost;
		private EcoSpace m_EcoSpace;
		private ElementHandle m_Handle;
		private StateChangedSubscriber m_StateChangedSubscriber;

		public TriggerControlsRefresher(Control triggerHost,
			EcoSpace ecoSpace, ElementHandle handle)
		{
			m_TriggerHost = triggerHost;
			m_EcoSpace = ecoSpace;
			m_Handle = handle;
			Resubscribe();
		}

		private void StateChanged()
		{
			/*m_TriggerHost.Controls.Clear();
			StatePageBuilder.BuildControls(m_TriggerHost, m_EcoSpace, m_Handle);
			Resubscribe();*/
		}
		// Subscribe to everything, and always resubscribe
		private void Resubscribe()
		{
			if (m_StateChangedSubscriber != null)
				m_StateChangedSubscriber.Deactivate();
			m_StateChangedSubscriber = new StateChangedSubscriber(this);
			m_Handle.SubscribeToElement(m_StateChangedSubscriber);
			if (m_Handle.Element == null)
				return;
			m_Handle.Element.SubscribeToValue(m_StateChangedSubscriber);
			IObject obj = m_Handle.Element as IObject;
			if (obj == null)
				return;
			IObjectStateMachine sm = obj.ObjectInstance.StateMachine;
			if (sm == null)
				return;
			sm.SubscribeToState(m_StateChangedSubscriber);
		}

		private sealed class StateChangedSubscriber: SubscriberAdapterBase
		{
			public StateChangedSubscriber(TriggerControlsRefresher subscriber): base(subscriber)
			{
			}

			protected override void DoReceive(object sender, EventArgs e, object actualSubscriber)
			{
				if (actualSubscriber == null)
					throw new ArgumentNullException("actualSubscriber");
				((TriggerControlsRefresher)actualSubscriber).StateChanged();
			}
		}
	}
#endregion
	///<summary>
	///This class builds controls representing the state machines of a type on a surface. It is used by the DefaultAutoForm/>
	///but can be used stand alone if there is need to quickly get a UI representations of an object's state machine and valid transitions.
	///</summary>
	public sealed class StatePageBuilder
	{
		private StatePageBuilder() { }
		///<summary>
		///Builds controls representing the state machine of the Element of the <paramref name="handle"/> on <paramref name="hostControl"/>.
		///</summary>
		///<param name="hostControl">The control used as container for created controls.</param>
		///<param name="ecoSpace">Used when bringing up new autoforms.</param>
		///<param name="handle">The handle is used for data binding.</param>
		///<param name="table">The html table taht you want to add controls to.</param>
		///<param name="myMethodBindings">List of bindings between controls and methods.</param>
		///<param name="autoForm">The form responsible for presentation.</param>
		///<param name="controlPrefix">Prefix that will be prepended to the name of your control (used for recursive nestling of state machine regions).</param>
		///<param name="response">The HttpResponse from the asp page.</param>
		///<param name="request">The HttpRequest from the asp page.</param>
		///<param name="session">The HttpSessionState from the asp page.</param>
		///<exception cref="ArgumentNullException">Thrown if <paramref name="hostControl"/> is null.</exception>
		///<exception cref="ArgumentNullException">Thrown if <paramref name="handle"/> is null.</exception>
		///<exception cref="ArgumentNullException">Thrown if <paramref name="ecoSpace"/> is null.</exception>
		public static TriggerControlsRefresher BuildControls(Control hostControl, EcoSpace ecoSpace,
			ElementHandle handle, Table table, IList myMethodBindings, AutoForm autoForm, string controlPrefix, HttpResponse response, HttpRequest request, HttpSessionState session)
		{
			if (handle == null)
				throw new ArgumentNullException("handle"); // do not localize
			if (handle == null)
				throw new ArgumentNullException("hostControl"); // do not localize
			if (ecoSpace == null)
				throw new ArgumentNullException("ecoSpace"); // do not localize
			IObject obj = handle.Element as IObject;
			if (obj != null)
				if (((IClass) obj.UmlType).StateMachine != null)
				{
					BuildRegionContainer(hostControl, obj.ObjectInstance.StateMachine.StateMachine, ecoSpace, handle, table, myMethodBindings, autoForm, controlPrefix, response, request, session);
					return new TriggerControlsRefresher(hostControl, ecoSpace, handle);
				}
			return null;
		}
		///<exception cref="ArgumentNullException">Thrown if <paramref name="hostControl"/> is null.</exception>
		///<exception cref="ArgumentNullException">Thrown if <paramref name="handle"/> is null.</exception>
		///<exception cref="ArgumentNullException">Thrown if <paramref name="regionContainer"/> is null.</exception>
		public static void BuildRegionContainer(Control hostControl, IRegionContainer regionContainer, EcoSpace ecoSpace,
			 ElementHandle handle, Table table, IList myMethodBindings, AutoForm autoForm, string controlPrefix, HttpResponse response, HttpRequest request, HttpSessionState session)
		{
			if (handle == null)
				throw new ArgumentNullException("handle"); // do not localize
			if (handle == null)
				throw new ArgumentNullException("hostControl"); // do not localize
			if (regionContainer == null)
				throw new ArgumentNullException("regionContainer"); // do not localize
			if (regionContainer is IState)
			{
				IState CurrentState = regionContainer as IState;
				Hashtable ht = new Hashtable();
				foreach (ITransition transition in CurrentState.Outgoing)
				{
					IMethodTrigger trigger = transition.Trigger as IMethodTrigger;
					if (trigger != null && !ht.ContainsKey(trigger))
					{
						ht[trigger] = trigger;
						MethodCallBuilder.BuildControlsForMethod( hostControl, ecoSpace, handle, (transition.Trigger as IMethodTrigger).Method, table, myMethodBindings, autoForm, CurrentState.Name + "SM", response, request, session ); // do not localize
					}
				}
			}
			foreach (IRegion region in 	regionContainer.Regions)
			{
				TableRow tableRow = ControlBuilder.MakeNewTableRow(controlPrefix + "RowMeth" + region.Name, table); // do not localize
				BuildRegion( hostControl, region, ecoSpace, handle, tableRow, myMethodBindings, autoForm, controlPrefix, response, request, session );
			}
		}

		///<exception cref="ArgumentNullException">Thrown if <paramref name="hostControl"/> is null.</exception>
		///<exception cref="ArgumentNullException">Thrown if <paramref name="handle"/> is null.</exception>
		///<exception cref="ArgumentNullException">Thrown if <paramref name="region"/> is null.</exception>
		public static void BuildRegion(Control hostControl, IRegion region, EcoSpace ecoSpace,
			ElementHandle handle, TableRow tableRow, IList myMethodBindings, AutoForm autoForm, string controlPrefix, HttpResponse response, HttpRequest request, HttpSessionState session)
		{
			if (handle == null)
				throw new ArgumentNullException("handle"); // do not localize
			if (hostControl == null)
				throw new ArgumentNullException("hostControl"); // do not localize
			if (region == null)
				throw new ArgumentNullException("region"); // do not localize

			IObject obj = handle.Element as IObject;
			if (obj == null)
				return;

			TableCell labelCell = ControlBuilder.MakeNewTableCell(controlPrefix + "CellLabelParam" + region.Name, tableRow); // do not localize
			TableCell controlCell = ControlBuilder.MakeNewTableCell(controlPrefix + "CellControlParam" + region.Name, tableRow); // do not localize
			labelCell.CssClass = EcoCssClassNames.EcoAutoFormLabelCell; // do not localize
			controlCell.CssClass = EcoCssClassNames.EcoAutoFormControlCell; // do not localize

			IObjectStateMachine sm = obj.ObjectInstance.StateMachine;
			if ((sm == null) || !sm.IsInRegion(region))
				return;
			IState currentState = sm.GetStates(region,StateFilter.AllTopLevel)[0];

			Label stateLabel = new Label();
			labelCell.Controls.Add(stateLabel);

			string regionName = region.Name;
			if (region.Container.Regions.Count == 1 && region.Container is IState)
				regionName = (region.Container as IState).Name;
			else if (regionName == String.Empty)
			{
				for (int i=0; i<region.Container.Regions.Count; i++)
					if (region.Container.Regions[i] == region)
						regionName = "subregion_" + i.ToString(CultureInfo.InvariantCulture); // do not localize!
			}

			stateLabel.Text = regionName + '.' + currentState.Name;

			if (currentState.Regions.Count > 0)
			{
				Table stateTable = ControlBuilder.MakeNewTable(controlPrefix + "TableRegion" + region.Name, controlCell); // do not localize
				stateTable.CssClass = EcoCssClassNames.EcoAutoFormStateTable;
				BuildRegionContainer(hostControl, currentState, ecoSpace, handle, stateTable, myMethodBindings, autoForm, controlPrefix, response, request, session );
			}
			else
			{
				Table methodTable = ControlBuilder.MakeNewTable(controlPrefix + "TableRegion" + region.Name, controlCell); // do not localize
				methodTable.CssClass = EcoCssClassNames.EcoAutoFormStateTable;

				foreach (IMethodTrigger trigger in sm.GetTriggers(region))
				{
					MethodCallBuilder.BuildControlsForMethod(hostControl, ecoSpace, handle, trigger.Method, methodTable, myMethodBindings, autoForm, region.Name + "SM", response, request, session ); // do not localize
				}
			}
		}
	}
}

